#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Parabolic TransformationMod01.fsh   by   roice3
//https://www.shadertoy.com/view/Ms3cWn
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
// Start Common  //
//
// View Helpers
// http://jamie-wong.com/2016/07/15/ray-marching-signed-distance-functions/
// 
//

/**
 * Return the normalized direction to march in from the eye point for a single pixel.
 * 
 * fieldOfView: vertical field of view in degrees
 * size: resolution of the output image
 * fragCoord: the x,y coordinate of the pixel in the output image
 */
vec3 rayDirection(float fieldOfView, vec2 size, vec2 fragCoord) {
    vec2 xy = fragCoord - size / 2.0;
    float z = size.y / tan(radians(fieldOfView) / 2.0);
    return normalize(vec3(xy, -z));
}

/**
 * Return a transform matrix that will transform a ray from view space
 * to world coordinates, given the eye point, the camera target, and an up vector.
 *
 * This assumes that the center of the camera is aligned with the negative z axis in
 * view space when calculating the ray marching direction. See rayDirection.
 */
mat3 viewMatrix(vec3 eye, vec3 center, vec3 up) {
    // Based on gluLookAt man page
    vec3 f = normalize(center - eye);
    vec3 s = normalize(cross(f, up));
    vec3 u = cross(s, f);
    return mat3(s, u, -f);
}

//
// CSG Helpers
// http://jamie-wong.com/2016/07/15/ray-marching-signed-distance-functions/
//

/**
 * Constructive solid geometry intersection operation on SDF-calculated distances.
 */
float intersectSDF(float distA, float distB) {
    return max(distA, distB);
}

/**
 * Constructive solid geometry union operation on SDF-calculated distances.
 */
float unionSDF(float distA, float distB) {
    return min(distA, distB);
}

/**
 * Constructive solid geometry difference operation on SDF-calculated distances.
 */
float differenceSDF(float distA, float distB) {
    return max(distA, -distB);
}

//
// Color functions
//

#define twopi 6.28319

// From https://www.shadertoy.com/view/ldtGDn
vec3 hsv2rgb (vec3 hsv) 
{ 
    // from HSV to RGB color vector
	hsv.yz = clamp (hsv.yz, 0.0, 1.0);
	return hsv.z*(0.63*hsv.y*(cos(twopi*(hsv.x + vec3(0.0, 2.0/3.0, 1.0/3.0))) - 1.0) + 1.0);
}

//
// Misc
//

// Repeat a suqare grid in two dimensions
void Mod2D( inout vec2 p, vec2 size ) 
{
	p = mod( p + size*0.5, size) - size*0.5;
}

//
// Complex number operations
//

vec2 C_Conj( vec2 c )
{
	return vec2( c.x, -c.y );
}

vec2 C_Mult( vec2 a, vec2 b )
{
	return vec2( a.x * b.x - a.y * b.y, a.y * b.x + a.x * b.y );
}

float C_MagSquared( vec2 c )
{
	return c.x * c.x + c.y * c.y;
}

vec2 C_Div( vec2 a, vec2 b )
{
	return C_Mult( a, C_Conj( b ) ) / C_MagSquared( b );
}

vec2 C_Inv( vec2 c )
{
	return C_Conj( c ) / C_MagSquared( c );
}

vec2 C_Sqrt( vec2 c )
{
	// Implement me!
	return c;
}

//
// Quaternion operations
//

//
// Mobius transformations
//

struct Mobius
{
	vec2 A;
	vec2 B;
	vec2 C;
	vec2 D;
};

Mobius M_Scale( in Mobius m, vec2 s )
{
	Mobius result;
	result.A = C_Mult( m.A, s );
	result.B = C_Mult( m.B, s );
	result.C = C_Mult( m.C, s );
	result.D = C_Mult( m.D, s );
	return m;
}

Mobius M_Normalize( in Mobius m )
{
	// See Visual Complex Analysis, p150
	vec2 k = C_Inv( C_Sqrt( m.A * m.D - m.B * m.C ) );
	return M_Scale( m, k );
}

Mobius M_Mult( in Mobius a, in Mobius b )
{
	Mobius result;
	result.A = a.A * b.A + a.B * b.C;
	result.B = a.A * b.B + a.B * b.D;
	result.C = a.C * b.A + a.D * b.C;
	result.D = a.C * b.B + a.D * b.D;
	return M_Normalize( result );
}

vec2 M_Apply( in Mobius m, in vec2 z )
{
	return C_Div( C_Mult( m.A, z ) + m.B, C_Mult( m.C, z ) + m.D );
}
// End Common  //
///////////////////////////////////
// buffer A prevoid
//
// Elementary transformations of hyperbolic space 1 (Parabolic), by Roice Nelson
// license: Public Domain
//
// This shows an "elementary" transformation of hyperbolic space in the upper half space model. 
// The visible plane is the "plane at infinity". The sphere is a horosphere that kisses the plane 
// at the origin, which is also the center of the horosphere and the single fixed point of the
// tranformation.
//
// I liberally repurposed code from the following:
// - The very helpful ray marching tutorial at: http://jamie-wong.com/2016/07/15/ray-marching-signed-distance-functions/
// - The beautiful particle shader at: https://www.shadertoy.com/view/ld3GWS
//

const int MAX_MARCHING_STEPS = 255;
const float MIN_DIST = 0.0;
const float MAX_DIST = 100.0;
const float EPSILON = 0.0001;

// Signed distance function for a sphere kissing the origin with radius r.
float sphereSdf(vec3 p, float r) 
{
    p.z -= r;
    return length(p) - r;
}

// Signed distance function for the z=0 plane
float planeSdf( vec3 p )
{
    return p.z;
}

float sceneSDF(vec3 samplePoint) {
    
	float plane = planeSdf( samplePoint );
    float sphere = sphereSdf( samplePoint, .75 );
    float combined = unionSDF( sphere, plane );
    return combined;
}

// Particle time constants
const float time_factor = 0.75;                               // Time in s factor, <1. for slow motion, >1. for faster movement

// Particle intensity constants
const float part_int_div = 40000.;                            // Divisor of the particle intensity. Tweak this value to make the particles more or less bright
const float part_int_factor_min = 0.1;                        // Minimum initial intensity of a particle
const float part_int_factor_max = 3.2;                        // Maximum initial intensity of a particle
const float mp_int = 12.;                                     // Initial intensity of the main particle
const float dist_factor = 3.;                                 // Distance factor applied before calculating the intensity
const float ppow = 1.9;  

// Particle color constants
const float part_min_hue = -0.13;                             // Minimum particle hue shift (spectrum width = 1.)
const float part_max_hue = 0.13;                              // Maximum particle hue shift (spectrum width = 1.)
const float part_min_saturation = 0.5;                        // Minimum particle saturation (0. to 1.)
const float part_max_saturation = 0.9;                        // Maximum particle saturation (0. to 1.)
const float hue_time_factor = 0.035;                          // Time-based hue shift
const float mp_hue = 0.5;                                     // Hue (shift) of the main particle
const float mp_saturation = 0.18;        

// Particle star constants
const vec2 part_starhv_dfac = vec2(9., 0.32);                 // x-y transformation vector of the distance to get the horizontal and vertical star branches
const float part_starhv_ifac = 0.25;                          // Intensity factor of the horizontal and vertical star branches
const vec2 part_stardiag_dfac = vec2(13., 0.61);              // x-y transformation vector of the distance to get the diagonal star branches
const float part_stardiag_ifac = 0.19;                        // Intensity factor of the diagonal star branches

const float mb_factor = 0.88;                                 // Mix factor for the multipass motion blur factor


vec3 getParticleColor_mp( float pint )
{
   float hue;
   float saturation;
   
   saturation = 0.75/pow(pint, 2.5) + mp_saturation;
   float time2 = time_factor*iTime;
   hue = hue_time_factor*time2 + mp_hue;

   return hsv2rgb(vec3(hue, saturation, pint));
}

float particleColorInt( vec2 p )
{
    float dist = length( p );
    vec2 uv = p;
    vec2 ppos = vec2( 0., 0. );
    
        // Draws the eight-branched star
        // Horizontal and vertical branches
        vec2 uvppos = uv - ppos;
        float distv = distance(uvppos*part_starhv_dfac + ppos, ppos);
        float disth = distance(uvppos*part_starhv_dfac.yx + ppos, ppos);
        // Diagonal branches
        vec2 uvpposd = 0.7071*vec2(dot(uvppos, vec2(1., 1.)), dot(uvppos, vec2(1., -1.)));
        float distd1 = distance(uvpposd*part_stardiag_dfac + ppos, ppos);
        float distd2 = distance(uvpposd*part_stardiag_dfac.yx + ppos, ppos);
        // Middle point intensity star inensity
        float pint1 = 1./(dist*dist_factor + 0.015) + 
            part_starhv_ifac/(disth*dist_factor + 0.01) + 
            part_starhv_ifac/(distv*dist_factor + 0.01) + 
            part_stardiag_ifac/(distd1*dist_factor + 0.01) + 
            part_stardiag_ifac/(distd2*dist_factor + 0.01);
        
        if (part_int_factor_max*pint1>6.)
        {
            float pint = part_int_factor_max*(pow(pint1, ppow)/part_int_div)*mp_int;
           	return pint;
        }
    
    return 0.;
}

/**
 * Return the shortest distance from the eyepoint to the scene surface along
 * the marching direction. If no part of the surface is found between start and end,
 * return end.
 * 
 * eye: the eye point, acting as the origin of the ray
 * marchingDirection: the normalized direction to march in
 * start: the starting distance away from the eye
 * end: the max distance away from the ey to march before giving up
 */
vec3 shortestDistanceToSurface(vec3 eye, vec3 marchingDirection, float start, float end) {
    float depth = start;
    float accum = 0.;
    for (int i = 0; i < MAX_MARCHING_STEPS; i++) 
    {
        vec3 current = eye + depth * marchingDirection;
        float dist = sceneSDF( current );
        if (dist < EPSILON) 
        {
            vec3 samplePoint = current;

            // Inversion
            float t = dot( samplePoint, samplePoint );
            samplePoint /= t;

            // Move the points and mod to get a repeating grid.
            float spacing = 0.15;
            samplePoint.xy += vec2( iTime*spacing/2., spacing/2. );
            Mod2D( samplePoint.xy, vec2( spacing, spacing ) );

			// Calc the point intentsity.
            float pint = particleColorInt( samplePoint.xy );
            return vec3( pint, depth, 0. );
        }

        depth += dist;
      
        if (depth >= end) 
        {
            return vec3( 0., end, 0. );
        }
    }
    
    return vec3( 0., end, 0. );
}

// Mobius
Mobius m;

//end buffer A prevoid
///////////////////////////////////////
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
// Start buffer A postvoid //
    // Setup Mobius (not currently using this, but will for other classes of transformations)
    float t = sqrt( 2. ) / 2.;
    m.A = vec2( 0., 0. );
    m.B = vec2( -1., 0. );
    m.C = vec2( 1., 0. );
    m.D = vec2( -1., 0. );
    
    // Setup the view.
	vec3 viewDir = rayDirection(45.0, iResolution.xy, fragCoord);
    vec3 eye = vec3(-2., -2., 1.5)*2.;
    vec3 lookat = vec3( 0., 0., 0.5 );
    mat3 viewToWorld = viewMatrix(eye, lookat, vec3(0.0, 0.0, 1.0));    
    vec3 worldDir = viewToWorld * viewDir;
    
    // Raymarch.
    vec3 distVec = shortestDistanceToSurface(eye, worldDir, MIN_DIST, MAX_DIST);

    // Color.
    vec3 color = vec3( 0., 0., 0. );
    if( distVec.x > 0. )
    {
        color = getParticleColor_mp( distVec.x );
    }
    
    // Multipass motion blur
    vec2 uv2 = fragCoord.xy / iResolution.xy;
    vec3 pcolor = texture2D(texture0,uv2).rgb*mb_factor;
    pcolor += color*0.9;
    fragColor = vec4( pcolor, 0. );

//end buffer A postvoid //
///////////////////////////////////

//	vec2 uv = fragCoord.xy / iResolution.xy;
//	fragColor = texture2D(texture0,uv);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

